/*
 * Decompiled with CFR 0.152.
 */
package ibm.nways.jdm.modelgen;

import ibm.nways.jdm.DestinationPropBook;
import ibm.nways.jdm.NavFieldOverride;
import ibm.nways.jdm.NavigationContext;
import ibm.nways.jdm.common.ModelInfo;
import ibm.nways.jdm.eui.IPInput;
import ibm.nways.jdm.eui.JDMInput;
import ibm.nways.jdm.eui.NumericInput;
import ibm.nways.jdm.eui.PropertySection;
import ibm.nways.jdm.eui.StringInput;
import ibm.nways.jdm.eui.StringInputRO;
import ibm.nways.jdm.modelgen.SnmpContextModel;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.io.Serializable;
import java.rmi.RemoteException;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public class SnmpConfigPanel
extends DestinationPropBook {
    protected static ResourceBundle enumStrings = null;
    protected static ResourceBundle myResources = null;
    private static String title = "Configuration";
    protected boolean containsWritableField = false;
    protected boolean containsCreatableField = false;
    protected SnmpContextModel SnmpContext_model;
    protected GeneralSection GeneralPropertySection;
    protected SNMPSection SNMPPropertySection;
    protected PollingSection PollingPropertySection;
    protected ModelInfo ConfigInfo;

    private static void loadStatics() {
        try {
            if (enumStrings == null) {
                enumStrings = ResourceBundle.getBundle("ibm.nways.jdm.modelgen.EnumeratedResources");
            }
            if (myResources == null) {
                myResources = ResourceBundle.getBundle("ibm.nways.jdm.modelgen.SnmpConfigPanelResources");
                return;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.out.println("Unable to access translation resources for panel SnmpConfig");
        }
    }

    public static String getTitle() {
        SnmpConfigPanel.loadStatics();
        if (myResources != null) {
            title = SnmpConfigPanel.getNLSString("SnmpConfigPanelTitle");
        }
        return title;
    }

    private static ResourceBundle getEnumStrings() {
        if (enumStrings == null) {
            SnmpConfigPanel.loadStatics();
        }
        return enumStrings;
    }

    public SnmpConfigPanel() {
        SnmpConfigPanel.loadStatics();
    }

    public Insets getInsets() {
        return new Insets(3, 3, 3, 3);
    }

    public String getDestinationTitle() {
        return SnmpConfigPanel.getTitle();
    }

    protected void getModels() {
        this.SnmpContext_model = (SnmpContextModel)this.getModel();
    }

    public void addSections() {
        this.getModels();
        this.addGeneralSection();
        this.addSNMPSection();
        this.addPollingSection();
        if (this.containsCreatableField) {
            this.addCreateButton();
        }
        if (this.containsWritableField) {
            this.addApplyButton();
        }
        this.addRefreshButton();
        this.addHelpButton();
        this.reset();
    }

    protected void addGeneralSection() {
        this.GeneralPropertySection = new GeneralSection();
        this.GeneralPropertySection.layoutSection();
        this.addSection(SnmpConfigPanel.getNLSString("GeneralSectionTitle"), this.GeneralPropertySection);
    }

    protected void addSNMPSection() {
        this.SNMPPropertySection = new SNMPSection();
        this.SNMPPropertySection.layoutSection();
        this.addSection(SnmpConfigPanel.getNLSString("SNMPSectionTitle"), this.SNMPPropertySection);
    }

    protected void addPollingSection() {
        this.PollingPropertySection = new PollingSection();
        this.PollingPropertySection.layoutSection();
        this.addSection(SnmpConfigPanel.getNLSString("PollingSectionTitle"), this.PollingPropertySection);
    }

    protected void displayMsg(String string) {
        if (this.getBrowser() != null) {
            this.getBrowser().displayMsg(string);
        }
    }

    protected static String getNLSString(String string) {
        if (myResources == null) {
            return string;
        }
        try {
            return myResources.getString(string);
        }
        catch (Exception exception) {
            return string;
        }
    }

    protected String getOverride(String string, String string2) {
        String string3 = null;
        try {
            string3 = NavFieldOverride.getFieldOverride((NavigationContext)this.getNavContext(), (String)string);
        }
        catch (ClassCastException classCastException) {
        }
        catch (MissingResourceException missingResourceException) {
        }
        catch (NullPointerException nullPointerException) {}
        if (string3 == null) {
            string3 = string2;
        }
        return string3;
    }

    public void reset() {
        try {
            if (this.SnmpContext_model != null) {
                this.ConfigInfo = this.SnmpContext_model.getConfig();
            }
        }
        catch (RemoteException remoteException) {
            System.out.println(remoteException);
            remoteException.printStackTrace();
        }
        super.reset();
    }

    public void apply() {
        this.ConfigInfo = new ModelInfo();
        super.apply();
        try {
            if (this.SnmpContext_model != null) {
                this.ConfigInfo = this.SnmpContext_model.setConfig(this.ConfigInfo);
            }
        }
        catch (RemoteException remoteException) {
            System.out.println(remoteException);
            remoteException.printStackTrace();
        }
        super.reset();
    }

    public class GeneralSection
    extends PropertySection {
        ModelInfo chunk;
        Component AddrField;
        boolean AddrFieldWritable = false;

        public GeneralSection() {
            SnmpConfigPanel.this = SnmpConfigPanel.this;
            ((Container)((Object)this)).setLayout(new GridBagLayout());
            this.setInsets(new Insets(5, 5, 5, 5));
        }

        protected Component createAddrField() {
            String string = SnmpConfigPanel.this.getOverride("ibm.nways.jdm.modelgen.SnmpContext.Config.Address.access", "read-only");
            boolean bl = this.AddrFieldWritable = string.equals("read-write") || string.equals("write-only");
            if (this.AddrFieldWritable) {
                IPInput iPInput = new IPInput();
                this.addRow(SnmpConfigPanel.getNLSString("AddrLabel"), (Component)iPInput);
                SnmpConfigPanel.this.containsWritableField = true;
                return iPInput;
            }
            StringInputRO stringInputRO = new StringInputRO();
            this.addRow(SnmpConfigPanel.getNLSString("AddrLabel"), (Component)stringInputRO);
            return stringInputRO;
        }

        protected Serializable getAddrField() {
            JDMInput jDMInput = (JDMInput)this.AddrField;
            Serializable serializable = (Serializable)jDMInput.getValue();
            return serializable;
        }

        protected void setAddrField(Object object) {
            if (object != null) {
                JDMInput jDMInput = (JDMInput)this.AddrField;
                jDMInput.setValue(object);
            }
        }

        protected boolean validateAddrField() {
            JDMInput jDMInput = (JDMInput)this.AddrField;
            return jDMInput.isValidValue();
        }

        public void layoutSection() {
            this.AddrField = this.createAddrField();
        }

        public void apply() {
            if (this.validateSection()) {
                if (this.AddrFieldWritable) {
                    SnmpConfigPanel.this.ConfigInfo.add("Config.Address", this.getAddrField());
                    return;
                }
            } else {
                SnmpConfigPanel.this.displayMsg(SnmpConfigPanel.getNLSString("errorsFoundMsg"));
            }
        }

        public void reset() {
            SnmpConfigPanel.this.displayMsg(SnmpConfigPanel.getNLSString("accessDataMsg"));
            try {
                this.setAddrField(SnmpConfigPanel.this.ConfigInfo.get("Config.Address"));
            }
            catch (NullPointerException nullPointerException) {}
            ((Container)((Object)this)).doLayout();
            SnmpConfigPanel.this.displayMsg(SnmpConfigPanel.getNLSString("endResetMsg"));
        }

        public boolean validateSection() {
            return true;
        }
    }

    public class SNMPSection
    extends PropertySection {
        ModelInfo chunk;
        Component ReadCommField;
        Component WriteCommField;
        Component PortField;
        Component TimeoutField;
        Component RetriesField;
        boolean ReadCommFieldWritable = false;
        boolean WriteCommFieldWritable = false;
        boolean PortFieldWritable = false;
        boolean TimeoutFieldWritable = false;
        boolean RetriesFieldWritable = false;

        public SNMPSection() {
            SnmpConfigPanel.this = SnmpConfigPanel.this;
            ((Container)((Object)this)).setLayout(new GridBagLayout());
            this.setInsets(new Insets(5, 5, 5, 5));
        }

        protected Component createReadCommField() {
            String string = SnmpConfigPanel.this.getOverride("ibm.nways.jdm.modelgen.SnmpContext.Config.ReadCommName.access", "read-write");
            String string2 = SnmpConfigPanel.this.getOverride("ibm.nways.jdm.modelgen.SnmpContext.Config.ReadCommName.length", "255");
            boolean bl = this.ReadCommFieldWritable = string.equals("read-write") || string.equals("write-only");
            if (this.ReadCommFieldWritable) {
                StringInput stringInput = new StringInput();
                stringInput.setMaxLength(Integer.parseInt(string2));
                this.addRow(SnmpConfigPanel.getNLSString("ReadCommLabel"), (Component)stringInput);
                SnmpConfigPanel.this.containsWritableField = true;
                return stringInput;
            }
            StringInputRO stringInputRO = new StringInputRO();
            this.addRow(SnmpConfigPanel.getNLSString("ReadCommLabel"), (Component)stringInputRO);
            return stringInputRO;
        }

        protected Serializable getReadCommField() {
            JDMInput jDMInput = (JDMInput)this.ReadCommField;
            Serializable serializable = (Serializable)jDMInput.getValue();
            return serializable;
        }

        protected void setReadCommField(Object object) {
            if (object != null) {
                JDMInput jDMInput = (JDMInput)this.ReadCommField;
                jDMInput.setValue(object);
            }
        }

        protected boolean validateReadCommField() {
            JDMInput jDMInput = (JDMInput)this.ReadCommField;
            return jDMInput.isValidValue();
        }

        protected Component createWriteCommField() {
            String string = SnmpConfigPanel.this.getOverride("ibm.nways.jdm.modelgen.SnmpContext.Config.WriteCommName.access", "read-write");
            String string2 = SnmpConfigPanel.this.getOverride("ibm.nways.jdm.modelgen.SnmpContext.Config.WriteCommName.length", "255");
            boolean bl = this.WriteCommFieldWritable = string.equals("read-write") || string.equals("write-only");
            if (this.WriteCommFieldWritable) {
                StringInput stringInput = new StringInput();
                stringInput.setMaxLength(Integer.parseInt(string2));
                this.addRow(SnmpConfigPanel.getNLSString("WriteCommLabel"), (Component)stringInput);
                SnmpConfigPanel.this.containsWritableField = true;
                return stringInput;
            }
            StringInputRO stringInputRO = new StringInputRO();
            this.addRow(SnmpConfigPanel.getNLSString("WriteCommLabel"), (Component)stringInputRO);
            return stringInputRO;
        }

        protected Serializable getWriteCommField() {
            JDMInput jDMInput = (JDMInput)this.WriteCommField;
            Serializable serializable = (Serializable)jDMInput.getValue();
            return serializable;
        }

        protected void setWriteCommField(Object object) {
            if (object != null) {
                JDMInput jDMInput = (JDMInput)this.WriteCommField;
                jDMInput.setValue(object);
            }
        }

        protected boolean validateWriteCommField() {
            JDMInput jDMInput = (JDMInput)this.WriteCommField;
            return jDMInput.isValidValue();
        }

        protected Component createPortField() {
            String string = SnmpConfigPanel.this.getOverride("ibm.nways.jdm.modelgen.SnmpContext.Config.RemotePort.access", "read-write");
            boolean bl = this.PortFieldWritable = string.equals("read-write") || string.equals("write-only");
            if (this.PortFieldWritable) {
                NumericInput numericInput = new NumericInput();
                numericInput.setMinMax(0L, 65535L);
                this.addRow(SnmpConfigPanel.getNLSString("PortLabel"), (Component)numericInput);
                SnmpConfigPanel.this.containsWritableField = true;
                return numericInput;
            }
            StringInputRO stringInputRO = new StringInputRO();
            this.addRow(SnmpConfigPanel.getNLSString("PortLabel"), (Component)stringInputRO);
            return stringInputRO;
        }

        protected Serializable getPortField() {
            JDMInput jDMInput = (JDMInput)this.PortField;
            Serializable serializable = (Serializable)jDMInput.getValue();
            return serializable;
        }

        protected void setPortField(Object object) {
            if (object != null) {
                JDMInput jDMInput = (JDMInput)this.PortField;
                jDMInput.setValue(object);
            }
        }

        protected boolean validatePortField() {
            JDMInput jDMInput = (JDMInput)this.PortField;
            return jDMInput.isValidValue();
        }

        protected Component createTimeoutField() {
            String string = SnmpConfigPanel.this.getOverride("ibm.nways.jdm.modelgen.SnmpContext.Config.Timeout.access", "read-write");
            boolean bl = this.TimeoutFieldWritable = string.equals("read-write") || string.equals("write-only");
            if (this.TimeoutFieldWritable) {
                NumericInput numericInput = new NumericInput();
                numericInput.setMinMax(0L, 60000L);
                this.addRow(SnmpConfigPanel.getNLSString("TimeoutLabel"), (Component)numericInput);
                SnmpConfigPanel.this.containsWritableField = true;
                return numericInput;
            }
            StringInputRO stringInputRO = new StringInputRO();
            this.addRow(SnmpConfigPanel.getNLSString("TimeoutLabel"), (Component)stringInputRO);
            return stringInputRO;
        }

        protected Serializable getTimeoutField() {
            JDMInput jDMInput = (JDMInput)this.TimeoutField;
            Serializable serializable = (Serializable)jDMInput.getValue();
            return serializable;
        }

        protected void setTimeoutField(Object object) {
            if (object != null) {
                JDMInput jDMInput = (JDMInput)this.TimeoutField;
                jDMInput.setValue(object);
            }
        }

        protected boolean validateTimeoutField() {
            JDMInput jDMInput = (JDMInput)this.TimeoutField;
            return jDMInput.isValidValue();
        }

        protected Component createRetriesField() {
            String string = SnmpConfigPanel.this.getOverride("ibm.nways.jdm.modelgen.SnmpContext.Config.Retries.access", "read-write");
            boolean bl = this.RetriesFieldWritable = string.equals("read-write") || string.equals("write-only");
            if (this.RetriesFieldWritable) {
                NumericInput numericInput = new NumericInput();
                numericInput.setMinMax(0L, 10L);
                this.addRow(SnmpConfigPanel.getNLSString("RetriesLabel"), (Component)numericInput);
                SnmpConfigPanel.this.containsWritableField = true;
                return numericInput;
            }
            StringInputRO stringInputRO = new StringInputRO();
            this.addRow(SnmpConfigPanel.getNLSString("RetriesLabel"), (Component)stringInputRO);
            return stringInputRO;
        }

        protected Serializable getRetriesField() {
            JDMInput jDMInput = (JDMInput)this.RetriesField;
            Serializable serializable = (Serializable)jDMInput.getValue();
            return serializable;
        }

        protected void setRetriesField(Object object) {
            if (object != null) {
                JDMInput jDMInput = (JDMInput)this.RetriesField;
                jDMInput.setValue(object);
            }
        }

        protected boolean validateRetriesField() {
            JDMInput jDMInput = (JDMInput)this.RetriesField;
            return jDMInput.isValidValue();
        }

        public void layoutSection() {
            this.addParagraph(SnmpConfigPanel.getNLSString("changeCommNameWarning"));
            this.ReadCommField = this.createReadCommField();
            this.WriteCommField = this.createWriteCommField();
            this.PortField = this.createPortField();
            this.TimeoutField = this.createTimeoutField();
            this.RetriesField = this.createRetriesField();
        }

        public void apply() {
            if (this.validateSection()) {
                if (this.ReadCommFieldWritable) {
                    SnmpConfigPanel.this.ConfigInfo.add("Config.ReadCommName", this.getReadCommField());
                }
                if (this.WriteCommFieldWritable) {
                    SnmpConfigPanel.this.ConfigInfo.add("Config.WriteCommName", this.getWriteCommField());
                }
                if (this.PortFieldWritable) {
                    SnmpConfigPanel.this.ConfigInfo.add("Config.RemotePort", this.getPortField());
                }
                if (this.TimeoutFieldWritable) {
                    SnmpConfigPanel.this.ConfigInfo.add("Config.Timeout", this.getTimeoutField());
                }
                if (this.RetriesFieldWritable) {
                    SnmpConfigPanel.this.ConfigInfo.add("Config.Retries", this.getRetriesField());
                    return;
                }
            } else {
                SnmpConfigPanel.this.displayMsg(SnmpConfigPanel.getNLSString("errorsFoundMsg"));
            }
        }

        public void reset() {
            SnmpConfigPanel.this.displayMsg(SnmpConfigPanel.getNLSString("accessDataMsg"));
            try {
                this.setReadCommField(SnmpConfigPanel.this.ConfigInfo.get("Config.ReadCommName"));
                this.setWriteCommField(SnmpConfigPanel.this.ConfigInfo.get("Config.WriteCommName"));
                this.setPortField(SnmpConfigPanel.this.ConfigInfo.get("Config.RemotePort"));
                this.setTimeoutField(SnmpConfigPanel.this.ConfigInfo.get("Config.Timeout"));
                this.setRetriesField(SnmpConfigPanel.this.ConfigInfo.get("Config.Retries"));
            }
            catch (NullPointerException nullPointerException) {}
            ((Container)((Object)this)).doLayout();
            SnmpConfigPanel.this.displayMsg(SnmpConfigPanel.getNLSString("endResetMsg"));
        }

        public boolean validateSection() {
            if (!this.validateReadCommField()) {
                return false;
            }
            if (!this.validateWriteCommField()) {
                return false;
            }
            if (!this.validatePortField()) {
                return false;
            }
            if (!this.validateTimeoutField()) {
                return false;
            }
            return this.validateRetriesField();
        }
    }

    public class PollingSection
    extends PropertySection {
        ModelInfo chunk;
        Component IntervalField;
        boolean IntervalFieldWritable = false;

        public PollingSection() {
            SnmpConfigPanel.this = SnmpConfigPanel.this;
            ((Container)((Object)this)).setLayout(new GridBagLayout());
            this.setInsets(new Insets(5, 5, 5, 5));
        }

        protected Component createIntervalField() {
            String string = SnmpConfigPanel.this.getOverride("ibm.nways.jdm.modelgen.SnmpContext.Config.PollingInterval.access", "read-write");
            boolean bl = this.IntervalFieldWritable = string.equals("read-write") || string.equals("write-only");
            if (this.IntervalFieldWritable) {
                NumericInput numericInput = new NumericInput();
                numericInput.setMinMax(1L, 86400L);
                this.addRow(SnmpConfigPanel.getNLSString("IntervalLabel"), (Component)numericInput);
                SnmpConfigPanel.this.containsWritableField = true;
                return numericInput;
            }
            StringInputRO stringInputRO = new StringInputRO();
            this.addRow(SnmpConfigPanel.getNLSString("IntervalLabel"), (Component)stringInputRO);
            return stringInputRO;
        }

        protected Serializable getIntervalField() {
            JDMInput jDMInput = (JDMInput)this.IntervalField;
            Serializable serializable = (Serializable)jDMInput.getValue();
            return serializable;
        }

        protected void setIntervalField(Object object) {
            if (object != null) {
                JDMInput jDMInput = (JDMInput)this.IntervalField;
                jDMInput.setValue(object);
            }
        }

        protected boolean validateIntervalField() {
            JDMInput jDMInput = (JDMInput)this.IntervalField;
            return jDMInput.isValidValue();
        }

        public void layoutSection() {
            this.IntervalField = this.createIntervalField();
        }

        public void apply() {
            if (this.validateSection()) {
                if (this.IntervalFieldWritable) {
                    SnmpConfigPanel.this.ConfigInfo.add("Config.PollingInterval", this.getIntervalField());
                    return;
                }
            } else {
                SnmpConfigPanel.this.displayMsg(SnmpConfigPanel.getNLSString("errorsFoundMsg"));
            }
        }

        public void reset() {
            SnmpConfigPanel.this.displayMsg(SnmpConfigPanel.getNLSString("accessDataMsg"));
            try {
                this.setIntervalField(SnmpConfigPanel.this.ConfigInfo.get("Config.PollingInterval"));
            }
            catch (NullPointerException nullPointerException) {}
            ((Container)((Object)this)).doLayout();
            SnmpConfigPanel.this.displayMsg(SnmpConfigPanel.getNLSString("endResetMsg"));
        }

        public boolean validateSection() {
            return this.validateIntervalField();
        }
    }
}

